/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class VWRouteDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7505L;
    protected int routeId;
    protected String condition = null;
    protected String description = null;
    protected VWAttributeInfo attributes = null;
    protected int sourceStepId;
    protected int destinationStepId;
    protected String name = null;
    protected boolean release = false;
    private VWMapNode myNode = null;
    private Object originalConnectorGraphicsInfosNode = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-19 01:21:59 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/6 $";
    }

    protected VWRouteDefinition(VWMapNode theNode, int theRouteId, int theSourceId, int theDestinationId) throws VWException {
        if (theNode == null) {
            throw new VWException("vw.api.VWRouteDefinitionInvalidNode", "theNode is invalid, (null).");
        }
        this.myNode = theNode;
        this.routeId = theRouteId;
        this.setSourceStepId(theSourceId);
        this.setDestinationStepId(theDestinationId);
    }

    protected VWRouteDefinition(VWMapNode theNode, int theRouteId, int theSourceId, int theDestinationId, String theCondition, String theName) throws VWException {
        if (theNode == null) {
            throw new VWException("vw.api.VWRouteDefinitionInvalidNode", "theNode is invalid, (null).");
        }
        this.myNode = theNode;
        this.routeId = theRouteId;
        this.sourceStepId = theSourceId;
        this.destinationStepId = theDestinationId;
        this.condition = theCondition;
        this.name = theName;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String theCondition) {
        this.condition = theCondition != null && theCondition.length() == 0 ? null : theCondition;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return this.attributes;
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        this.attributes = theAttributeInfo;
    }

    protected Hashtable getAttributes() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        if (this.attributes == null) {
            this.attributes = new VWAttributeInfo();
        }
        this.attributes.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        if (this.attributes == null) {
            return null;
        }
        return VWAttributeInfo.getAttributeNames(this.attributes.attributes);
    }

    public VWMapNode getSourceStep() throws VWException {
        return this.getNode().getMap().getStep(this.sourceStepId);
    }

    public int getSourceStepId() {
        return this.sourceStepId;
    }

    public void setSourceStepId(int theSourceStepId) throws VWException {
        this.getNode().getMap().getStep(theSourceStepId);
        this.sourceStepId = theSourceStepId;
    }

    public VWMapNode getDestinationStep() throws VWException {
        return this.getNode().getMap().getStep(this.destinationStepId);
    }

    public int getDestinationStepId() {
        return this.destinationStepId;
    }

    public void setDestinationStepId(int theDestinationStepId) throws VWException {
        if (theDestinationStepId == this.sourceStepId) {
            throw new VWException("vw.api.VWRouteDefinitionInvalidRouteToSelf", "Attempt to create a route with same source and destination ids: {0}.", String.valueOf(theDestinationStepId));
        }
        if (theDestinationStepId == 0) {
            throw new VWException("vw.api.VWRouteDefinitionInvalidDestinationFirstStep", "A route cannot have the launch step or a start step as it''s destination.");
        }
        this.getNode().getMap().getStep(theDestinationStepId);
        this.destinationStepId = theDestinationStepId;
    }

    public String getName() {
        VWSession session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (session != null) {
            try {
                return session.translate(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    public boolean getRelease() {
        return this.release;
    }

    public void setRelease(boolean theRelease) {
        this.release = theRelease;
    }

    public int getRouteId() {
        return this.routeId;
    }

    protected VWMapNode getNode() {
        return this.myNode;
    }

    protected void setNode(VWMapNode aNode) {
        this.myNode = aNode;
    }

    public String toString() {
        return this.name + "(" + String.valueOf(this.sourceStepId) + "->" + String.valueOf(this.destinationStepId) + ")";
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRouteDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<Route\n");
        theBuffer.append(ATTRIB_INDENT + "SourceStepId=\"" + VWXMLHandler.toXMLString(Integer.toString(this.sourceStepId)) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "DestinationStepId=\"" + VWXMLHandler.toXMLString(Integer.toString(this.destinationStepId)) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "RouteId=\"" + VWXMLHandler.toXMLString(Integer.toString(this.routeId)) + "\"");
        if (this.name != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"");
        }
        if (this.getDescription() != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"");
        }
        if (this.condition != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Condition=\"" + VWXMLHandler.toXMLString(this.condition) + "\"");
        }
        if (this.release) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Release=\"" + VWXMLHandler.booleanToString(this.release) + "\"");
        }
        if (this.attributes != null) {
            theBuffer.append(">\n");
            this.attributes.toXML(theBuffer, ATTRIB_INDENT);
            theBuffer.append("\t\t\t</Route>\n");
        } else {
            theBuffer.append("/>\n");
        }
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRouteDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        VWWorkflowDefinition wfdef = this.getSourceStep().getMap().getWorkflow();
        if (wfdef.getWorkflowCollection() == null) {
            throw new VWException("vw.api.VWRouteDefinitionNullWorkflowCollection", "The XPDL string cannot be created for this route definition. The necessary reference to a containing workflow collection definition is null. \nEnsure that the workflow collection definition containing this route definition is specified.");
        }
        String idPrefix = "Workflow" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.getSourceStep().getMap().getName()) + ".";
        theBuffer.append(indentA + "<Transition Id=\"" + idPrefix + VWAssociationTargetType.typeToString(2) + Integer.toString(this.getRouteId()) + "\" ");
        if (this.name != null) {
            theBuffer.append("Name=\"" + VWXMLHandler.toXMLString(this.name) + "\" ");
        }
        idPrefix = idPrefix + VWAssociationTargetType.typeToString(1);
        theBuffer.append("From=\"" + idPrefix + Integer.toString(this.sourceStepId) + "\" To=\"" + idPrefix + Integer.toString(this.destinationStepId) + "\"");
        if (this.release) {
            theBuffer.append(" fn:Release=\"" + VWXMLHandler.booleanToString(this.release) + "\"");
        }
        theBuffer.append(">\n");
        if (this.condition != null) {
            theBuffer.append(indentB + "<Condition Type=\"CONDITION\">" + VWXMLHandler.toXMLString(this.condition) + "</Condition>\n");
        }
        if (this.description != null) {
            theBuffer.append(indentB + "<Description>" + VWXMLHandler.toXMLString(this.description) + "</Description>\n");
        }
        if (this.originalConnectorGraphicsInfosNode != null) {
            VWXMLHandler.writeXMLNode(this.originalConnectorGraphicsInfosNode, indentB, theBuffer);
        }
        if (this.attributes != null) {
            theBuffer.append(indentB + "<fn:Route>\n");
            this.attributes.toXML(theBuffer, indentC);
            theBuffer.append(indentB + "</fn:Route>\n");
        }
        theBuffer.append(indentA + "</Transition>\n");
    }

    public void validate(Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(null, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        String serverConditionString = null;
        try {
            serverConditionString = this.getConditionAsServerString();
        }
        catch (Exception e) {
            VWString theMessage = new VWString("vw.api.VWRouteDefinitionErrorConvertClientConditionToServerCondition", "Route condition error converting client condition to server condition, ({0})", e.getMessage());
            VWValidationError theError = new VWValidationError(2, 1, this.getName(), null, theMessage.toString(), this.getSourceStep().getMap().getName(), this.getSourceStepId(), this.routeId);
            validationContext.addValidationError(theError);
        }
        if (serverConditionString != null) {
            VWCompiledExpr compRes;
            VWWorkflowSignature myBaseWflSignature;
            VWWorkflowSignature myWflSignature = this.myNode.getMap().getWorkflow().getWorkflowSignature(validationContext);
            String[] theErrorStrings = VWExpr.compileVWExpr(serverConditionString, myWflSignature, myBaseWflSignature = this.myNode.getMap().getWorkflow().getBaseWorkflowSignature(validationContext), null, null, true, compRes = new VWCompiledExpr());
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    VWString theMessage = new VWString("vw.api.VWRouteDefinitionSyntaxError", "Route condition parsing error, ({0})", theErrorStrings[i]);
                    VWValidationError theError = new VWValidationError(2, 1, this.getName(), serverConditionString, theMessage.toString(), this.getSourceStep().getMap().getName(), this.getSourceStepId(), this.routeId);
                    validationContext.addValidationError(theError);
                }
            } else if (compRes.getResultIsArray() || compRes.getResultType() != 4) {
                VWString theMessage = new VWString("vw.api.VWRouteDefinitionConditionNotBoolean", "Route condition expression must be boolean, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                VWValidationError theError = new VWValidationError(2, 1, this.getName(), serverConditionString, theMessage.toString(), this.getSourceStep().getMap().getName(), this.getSourceStepId(), this.routeId);
                validationContext.addValidationError(theError);
            }
        }
    }

    protected String getConditionAsServerString() throws VWException {
        String serverString = null;
        int nIndex = -1;
        if (this.condition == null) {
            return null;
        }
        serverString = this.condition;
        nIndex = serverString.indexOf("ALL");
        while (nIndex != -1) {
            serverString = this.replaceResponseString(serverString, nIndex, " = F_ResponseCount");
            nIndex = serverString.indexOf("ALL", nIndex + 1);
        }
        nIndex = serverString.indexOf("NONE");
        while (nIndex != -1) {
            serverString = this.replaceResponseString(serverString, nIndex, " = 0");
            nIndex = serverString.indexOf("NONE", nIndex + 1);
        }
        nIndex = serverString.indexOf("ANY");
        while (nIndex != -1) {
            serverString = this.replaceResponseString(serverString, nIndex, " > 0");
            nIndex = serverString.indexOf("ANY", nIndex + 1);
        }
        nIndex = serverString.indexOf("COUNT");
        while (nIndex != -1) {
            serverString = this.replaceResponseString(serverString, nIndex, "");
            nIndex = serverString.indexOf("COUNT", nIndex + 1);
        }
        return serverString;
    }

    private String replaceResponseString(String serverString, int nIndex, String subString) throws VWException {
        String newServerString = null;
        int nStartIndex = -1;
        int nEndIndex = -1;
        String response = null;
        String oldServerString = serverString;
        newServerString = serverString.substring(0, nIndex);
        nStartIndex = (serverString = serverString.substring(nIndex)).indexOf("(");
        if (nStartIndex != -1) {
            if (this.parenGoesWithWord(serverString, nStartIndex)) {
                nEndIndex = serverString.indexOf(")");
                response = serverString.substring(nStartIndex + 1, nEndIndex);
                response = response.trim();
                nIndex = this.findResponseIndex(response);
                newServerString = newServerString + " F_Responses[" + nIndex + "] ";
                newServerString = newServerString + subString;
                if (nIndex + 1 <= serverString.length()) {
                    newServerString = newServerString + serverString.substring(nEndIndex + 1);
                }
                return newServerString;
            }
            return oldServerString;
        }
        return oldServerString;
    }

    private int findResponseIndex(String response) throws VWException {
        if (this.myNode instanceof VWStepDefinition) {
            String[] responses = ((VWStepDefinition)this.myNode).getResponses();
            if (response == null || responses == null) {
                throw new VWException("vw.api.VWRouteDefinitionNullResponse", "Route condition contains a null response or (more probably) the step contains no responses");
            }
            for (int nIndex = 0; nIndex < responses.length; ++nIndex) {
                if (!response.equals(responses[nIndex])) continue;
                return nIndex + 1;
            }
            throw new VWException("vw.api.VWRouteDefinitionInvalidResponses", "Route condition contains a response ({0}), which is not a valid response for the step the route begins at. Perhaps the responses were changed after the route condition was created?", response);
        }
        throw new VWException("vw.api.VWRouteDefinitionNoResponses", "Attempt to find index of a response in a node type which cannot contain responses.");
    }

    private boolean parenGoesWithWord(String theString, int parenIndex) {
        int endOfWordIndex = 0;
        if (theString.startsWith("ANY") || theString.startsWith("ALL")) {
            endOfWordIndex += 3;
        } else if (theString.startsWith("NONE")) {
            endOfWordIndex += 4;
        } else if (theString.startsWith("COUNT")) {
            endOfWordIndex += 5;
        }
        String theGap = theString.substring(endOfWordIndex, parenIndex);
        for (int i = 0; i < theGap.length(); ++i) {
            if (Character.isWhitespace(theGap.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        try {
            VWRouteDefinition clonedRoute = (VWRouteDefinition)super.clone();
            clonedRoute.myNode = null;
            return clonedRoute;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected VWSession getSession() throws VWException {
        if (this.myNode != null && this.myNode.getMap() != null && this.myNode.getMap().getWorkflow() != null) {
            return this.myNode.getMap().getWorkflow().getSession();
        }
        return null;
    }

    protected void setOriginalConnectorGraphicsInfosNode(Object obj) {
        this.originalConnectorGraphicsInfosNode = obj;
    }

    protected Object getOriginalConnectorGraphicsInfosNode() {
        return this.originalConnectorGraphicsInfosNode;
    }
}

